/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;


import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.Toast;

public class SweepDraw extends View implements OnTouchListener{ //  
    private static final String TAG = "SweepDraw";
    
    private int g_Y_TopBorder=100;
    private int g_Y_BtmBorder=600;
    private int g_X_LeftBorder=100;
    private int g_X_RightBorder=1000;
    private int g_TraceWidth = 5;
    private int g_nextXPoint = 0;
    private int g_passCountA_Int=0;
    private int g_passCountB_Int=0;
    private int g_passCountC_Int=0;
    private int g_gridFreqPointInt=0;
    private int g_gridLevelPointInt=0;
    private int g_gridFreqPointAInt=0;
    private int g_gridFreqPointBInt=0;
    
    private String g_gridFreqPointA_Str="";
    private String g_gridLevelPointA_Str="";
    private String g_gridFreqPointB_Str="";
    private String g_gridLevelPointB_Str="";
    private String g_gridFreqPointB_A_Str="";
    private String g_A_B_LevelDiff_Str="";
    private String g_B_A_LevelDiff_Str="";
        
    private boolean g_SpotInfoA_b=false;
    
    private float g_previousX=100;
    private float g_previousY =100;
    private float g_X_Spot_Flt =100;
    private float g_Y_Spot_Flt =100;
    private float g_X_SpotA_Flt =0;
    private float g_Y_SpotA_Flt =0;
    private float g_X_SpotB_Flt =0;
    private float g_Y_SpotB_Flt =0;
    private float g_gridLevelPointA_Flt=0;
    private float g_gridLevelPointB_Flt=0;
    
    private  Point g_sweepPoint = new Point();
    private  Point g_sweepPointA = new Point();
    private  Point g_sweepPointB = new Point();

    
    private List<Point> points = new ArrayList<Point>();
    protected Paint paint = new Paint();

    public SweepDraw(Context context) { //constructor
        super(context);
        setFocusable(true);
        setFocusableInTouchMode(true);
        this.setOnTouchListener(this);        
        paint.setColor(Color.BLACK);
        paint.setAntiAlias(true);
    }

    @Override
    public void onDraw(Canvas canvas) {
    	// variables for onDraw
    	int s = 100; //empty pixel border width - leave room for widgets around outside of grid
    	int b = 6;  //border width
    	int c = b/2;
    	int t = s-c;
    	int dB = 0;
    	float xStep = 0;
    	float yStep = 0;
    	int x,y,n,f;
        // calculations for onDraw
    	int w = getWidth();
    	int h = getHeight();
    	xStep = ((w-2*s)/10);
    	yStep = ((h-2*s)/10);
    	g_Y_TopBorder = s;
    	g_Y_BtmBorder=h-s;
    	g_X_LeftBorder=t;
    	g_X_RightBorder=w-t;
    	// save the canvas dimensions for static access
    	NS3_App.sCanvasWidth=w;
    	NS3_App.sCanvasHeight=h;
    	NS3_App.sg_X_LeftBorder = t;
    	NS3_App.sg_Y_TopBorder = s;
    	NS3_App.sg_Y_BtmBorder = h-s;
    	NS3_App.sg_X_RightBorder = w-t; 
    	NS3_App.sg_X_Center = w/2; 
    	//paint the border
        paint.setStrokeWidth(5);
        canvas.drawLine(g_X_LeftBorder, g_Y_TopBorder, g_X_RightBorder, g_Y_TopBorder, paint);//border top
        canvas.drawLine(g_X_LeftBorder, g_Y_BtmBorder, g_X_RightBorder, g_Y_BtmBorder, paint);//border bottom
        canvas.drawLine(g_X_LeftBorder, g_X_LeftBorder, g_X_LeftBorder, (h-t), paint);// border left
        canvas.drawLine(g_X_RightBorder, g_X_LeftBorder, g_X_RightBorder, (h-t), paint);//border right
    	// paint and label the grid
        paint.setStrokeWidth(1);
        y = s;
        if(NS3_App.sg_10dB_Div_Yaxis_b){
        	dB = 20; //10 dB per div ref level dBm
        }else{
        	dB = 0;
        }
        for (n=1; n<11; n++){ // draw horizontal grid lines
        	y += (int)(yStep+.5);
            if(NS3_App.sg_10dB_Div_Yaxis_b){
            	dB -= 10;
            }else{
            	dB -= 2;
            }
            canvas.drawLine(s, y, (w-s), y, paint);
            paint.setTextSize(15);
            canvas.drawText(Integer.toString(dB), s+5, y-3, paint);
            canvas.drawText(Integer.toString(dB), w-s-25, y-3, paint);
        }
        x = s;
        f = -5;
        canvas.drawText(Integer.toString(f), x-5, h-s+15, paint);
        for (n=1; n<11; n++){ // draw vertical grid lines
        	x += (int)(xStep+.5);
        	f++;
            canvas.drawLine(x, s, x , (h-s), paint);
            if (f < 1)canvas.drawText(Integer.toString(f), x-5, h-s+15, paint);
            else canvas.drawText("+" + Integer.toString(f), x-5, h-s+15, paint);
        }	    
        paint.setTextSize(38);
        canvas.drawText("NimbleSig III RF Signal Generator - Swept Frequency Response" , 70, 40, paint);

        paint.setTextSize(8);
        canvas.drawText("  ver: " + Integer.toString(20130122), 1130, 95, paint);

        paint.setTextSize(24);               
        canvas.drawText("Step Frequency", g_X_LeftBorder+200,g_Y_TopBorder-35,paint);
        canvas.drawText(NS3_App.sg_SweepCurrentFreqHz_Str + " Hz.", g_X_LeftBorder+200,g_Y_TopBorder-10,paint);

        if(NS3_App.sg_NormalizeMode_b) canvas.drawText("0dB Normalized", g_X_LeftBorder+410,g_Y_TopBorder-10,paint);
        else if(NS3_App.sg_10dB_Div_Yaxis_b) canvas.drawText("Absolute Level dBm", g_X_LeftBorder+395,g_Y_TopBorder-10,paint);
        else canvas.drawText("Ref. Level: "+String.valueOf(NS3_App.sg_Yaxis_RefLevel_dBm_Int)  + "dBm",
        		g_X_LeftBorder+395,g_Y_TopBorder-10,paint);
        
        canvas.drawText("Step Level", 750,g_Y_TopBorder-35,paint);
        canvas.drawText(NS3_App.sMeasuredRFLevel_dBm_Str +" dBm",750,g_Y_TopBorder-10,paint);

        canvas.drawText("Freq./Div", g_X_LeftBorder,g_Y_TopBorder-35,paint);
        canvas.drawText(NS3_App.sg_HzPerDiv_Int_Str, g_X_LeftBorder,g_Y_TopBorder-10,paint);

        canvas.drawText("Span", g_X_RightBorder-150,g_Y_TopBorder-35,paint);
        canvas.drawText(NS3_App.sg_SweepSpanFreqHz_Str,g_X_RightBorder-150,g_Y_TopBorder-10,paint);
        
        canvas.drawText("Center Frequency Hz.",510,580,paint);
        canvas.drawText(NS3_App.sg_SweepCenterFreqHz_Str,510,610,paint);
        
        canvas.drawText("Start Frequency",g_X_LeftBorder-70,580,paint);
        canvas.drawText(NS3_App.sg_SweepStartFreqHz_Str, g_X_LeftBorder-70,610,paint);
        
        canvas.drawText("Stop Frequency",g_X_RightBorder-80,580,paint);
        canvas.drawText(NS3_App.sg_SweepStopFreqHz_Str,g_X_RightBorder-80,610,paint); 
        
        if(g_SpotInfoA_b){
	    	canvas.drawText("Marker A: ***",250,580,paint);
	    	canvas.drawText("Marker B:",800,580,paint);
        }else{
	    	canvas.drawText("Marker A:",250,580,paint);
	    	canvas.drawText("Marker B: ***",800,580,paint);
        }	
        canvas.drawText(g_gridLevelPointA_Str,250,610,paint); 
        canvas.drawText(g_gridFreqPointA_Str,250,640,paint); 
        paint.setStrokeWidth(10);
//    	canvas.drawPoint(g_sweepPoint.x, g_sweepPoint.y, paint);  
    	canvas.drawPoint(g_sweepPointA.x, g_sweepPointA.y, paint);  
    	canvas.drawPoint(g_sweepPointB.x, g_sweepPointB.y, paint);  
        canvas.drawText("A",g_X_SpotA_Flt,g_Y_SpotA_Flt-10,paint); 
        canvas.drawText(g_gridLevelPointB_Str,800,610,paint); 
        canvas.drawText(g_gridFreqPointB_Str,800,640,paint); 
        canvas.drawText("B",g_X_SpotB_Flt,g_Y_SpotB_Flt-10,paint); 
        canvas.drawText(g_gridFreqPointB_A_Str,500,640,paint); 
        canvas.drawText(g_A_B_LevelDiff_Str,g_X_LeftBorder-70,640,paint); 
        canvas.drawText(g_B_A_LevelDiff_Str,g_X_RightBorder-80,640,paint); 
        

        // paint the trace with lines or dot
        paint.setStrokeWidth(2);
        for (Point point : points) {
        	if(g_previousX > point.x){
            	g_previousX=point.x-1;
        	}
        	if(NS3_App.sg_SweepStart){
            	NS3_App.sg_SweepStart = false; 
        	}
          if((NS3_App.sg_SweepStartNew)){
            	canvas.drawPoint(point.x, point.y, paint);  //start each sweep with a dot on left edge
            	NS3_App.sg_SweepStartNew=false;
            	g_nextXPoint = 0;
            }else{
            canvas.drawLine(g_previousX, g_previousY, point.x, point.y, paint);
            }
          g_previousX=point.x;
          g_previousY=point.y;
        }
    }

    public boolean onTouch(View view, MotionEvent event) {
        //if(event.getAction() != MotionEvent.ACTION_DOWN)
        //return super.onTouchEvent(event);
    	g_sweepPoint.x = event.getX();
    	g_sweepPoint.y = event.getY();
    	if(g_sweepPoint.y < NS3_App.sg_Y_TopBorder)return true;
    	if((g_sweepPoint.x < NS3_App.sg_X_LeftBorder)||
    	   (g_sweepPoint.x > NS3_App.sg_X_RightBorder))return true;
    	if(g_sweepPoint.y > NS3_App.sg_Y_BtmBorder){
    		if(g_sweepPoint.x < NS3_App.sg_X_Center)
    			g_SpotInfoA_b=true;
    		else
    			g_SpotInfoA_b=false;
    		return true;
    	}
        g_X_Spot_Flt = g_sweepPoint.x;
        g_Y_Spot_Flt = g_sweepPoint.y;
        if(g_SpotInfoA_b){
        	g_X_SpotA_Flt=g_X_Spot_Flt;
        	g_Y_SpotA_Flt=g_Y_Spot_Flt;
        	g_sweepPointA.x=g_sweepPoint.x;
        	g_sweepPointA.y=g_sweepPoint.y;
        }else{
        	g_X_SpotB_Flt=g_X_Spot_Flt;
        	g_Y_SpotB_Flt=g_Y_Spot_Flt;        	        	
        	g_sweepPointB.x=g_sweepPoint.x;
        	g_sweepPointB.y=g_sweepPoint.y;
        }
        g_gridFreqPointInt=((int) NS3_App.sg_HzPerPixel_Flt*
        		( (int)g_X_Spot_Flt - NS3_App.sg_X_LeftBorder))+NS3_App.sg_SweepStartFreqHz; 
        float dB_Offset=(g_Y_Spot_Flt - NS3_App.sg_Y_TopBorder)*NS3_App.sg_dB_PerPixel_Flt*10;
        int dB_OffsetInt=(int)(dB_Offset+.5);
        dB_Offset=(float)dB_OffsetInt/10;
        Float spotLevel_dB_Flt = (float)1.0;
        if(NS3_App.sg_Scale_dB_Div_Int == 10){
        	int spotLevel_dB_Int =(int) (10*(NS3_App.sg_Yaxis_RefLevel_dBm_Int-dB_Offset)+.5);
            spotLevel_dB_Flt=(float)spotLevel_dB_Int/10;
        }else{
        	spotLevel_dB_Flt=-dB_Offset;
        }
        if(g_SpotInfoA_b){
	        g_gridFreqPointA_Str=spaceDelimiter(g_gridFreqPointInt)  +" Hz.";
	        g_gridFreqPointAInt = g_gridFreqPointInt;
	        g_gridLevelPointA_Str= String.valueOf(spotLevel_dB_Flt) +" dB";
//	        float gridLevelA_Flt = (float)(spotLevel_dB_Flt*10+.5);
//	        int gridLevelA_Int=(int)gridLevelA_Flt;
//	        g_gridLevelPointA_Flt=(float)gridLevelA_Int/10;
	        g_gridLevelPointA_Flt=spotLevel_dB_Flt;
	        
        }else{
	        g_gridFreqPointB_Str=spaceDelimiter(g_gridFreqPointInt) +" Hz.";
	        g_gridFreqPointBInt = g_gridFreqPointInt;
	        g_gridLevelPointB_Str= String.valueOf(spotLevel_dB_Flt) +" dB";
//	        float gridLevelB_Flt = (float)(spotLevel_dB_Flt*10+.5);
//	        int gridLevelB_Int=(int)gridLevelB_Flt;
//	        g_gridLevelPointB_Flt=(float)gridLevelB_Int/10;
	        g_gridLevelPointB_Flt=spotLevel_dB_Flt;
        }
        g_gridFreqPointB_A_Str = "A-B = "+spaceDelimiter(g_gridFreqPointAInt-g_gridFreqPointBInt) + " Hz.";
        
        float A_B_LevelDiff_Flt =  (g_gridLevelPointA_Flt-g_gridLevelPointB_Flt)*10+(float).5;
        int A_B_LevelDiff_int =  (int) A_B_LevelDiff_Flt;
        A_B_LevelDiff_Flt = (float)A_B_LevelDiff_int/10;
        g_A_B_LevelDiff_Str = "A-B = " + String.valueOf(A_B_LevelDiff_Flt) + " dB";
        
        float B_A_LevelDiff_Flt =  (g_gridLevelPointB_Flt-g_gridLevelPointA_Flt)*10+(float).5;
        int B_A_LevelDiff_int =  (int) B_A_LevelDiff_Flt;
        B_A_LevelDiff_Flt = (float)B_A_LevelDiff_int/10;        
        g_B_A_LevelDiff_Str = "B-A = " + String.valueOf(B_A_LevelDiff_Flt) + " dB";
        
        invalidate();
        return true;
    }
    
    public void drawTrace(int x, int y){
    	if(NS3_App.sg_refreshScreen){//clear the screen
            points.clear();
            g_nextXPoint = 0;
            NS3_App.sg_refreshScreen=false;
    	}
    	Point point = new Point();
    	g_TraceWidth = 2;
    	point.x=x;
    	point.y=y;
        points.add(g_nextXPoint,point);
        // limit the record size of the array to the Xaxis pixel count
        invalidate();
       	g_nextXPoint++;//set back to 0 by onDraw at the beginning of each sweep
    	g_passCountB_Int++;
    }

    // convert int to string and add space delimiters for GUI display
    private String spaceDelimiter(int freq_Int){
    	String freqDelimited_Str = String.valueOf(freq_Int);
        char tempChr[]=freqDelimited_Str.toCharArray();
        int l=freqDelimited_Str.length();
        int space1=l-4;
        int space2=l-7;
        String tempStr="";
        for(int i=0;i<l;i++){
        	tempStr+=String.valueOf(tempChr[i]);
        	if((i==space1)|(i==space2))tempStr+=' ';
        }     	
    	return tempStr;
    }
}

class Point {
    float x, y;

    @Override
    public String toString() {
        return x + ", " + y;
    }    
}