.module/RAM       audio_isr;
{----------------------------------------------------------------------------}
{                  Copyright (C) Johan B. Forrer, 1996 			     }
{----------------------------------------------------------------------------}

.ENTRY input_isr, input_init;
.EXTERNAL  digi_bfo;
.EXTERNAL  LMS;
.EXTERNAL  sigout_R, sigout_L, rx_buf, tx_buf;
.GLOBAL CW_switch;

.const FILTER_SIZE=121;        { CW }
.const DEC4_SIZE=33;	      { by 4 decimation/interpolation filter }

.var/dm/circ            dl[FILTER_SIZE];        { delay line for filter }
.var/dm/circ		d4_input[DEC4_SIZE];	{ input by-8 decimator }
.var/dm/circ		d4_output[DEC4_SIZE];	{ output by-8 interpolator }
.var/dm                 filter_dl_ptr;          { Filter delay line pointer }
.var/dm 		d4_in_ptr;		{ decimator variables }
.var/dm 		d4_out_ptr;
.var/dm			d4_cntr;
.var/dm			CW_switch;		{ CW filter selection }
{----------------------------------------------------------------------------}
{ Code initialization call			                             }
{----------------------------------------------------------------------------}
input_init:

{ init_filter() is used to set up the DAG registers used by the filter }
{ following a reset.                                                   }
	m0=1;
	m4=1;

	i0=^dl;
	dm(filter_dl_ptr)=i0;
	ar=0;			{ disable CW filters }
	dm(CW_switch)=ar;

	i0=^d4_input;
	dm(d4_in_ptr)=i0;		{ decimator variables }

	i0=^d4_output;
	dm(d4_out_ptr)=i0;

	ar=0;
	dm(d4_cntr)=ar;

	rts;

{----------------------------------------------------------------------------}
{   SPORT0 interrupt handler						     }
{----------------------------------------------------------------------------}
input_isr:
        ena sec_reg;                	{ use shadow register bank           }

	mr1=dm(sigout_R);		{ pick up AFSK out/input signal      }
        dm (tx_buf + 1) = mr1;      	{ filtered output to SPORT (to spkr) }
	mr1=dm(sigout_L);
        dm (tx_buf + 2) = mr1;

        ax0 = dm (rx_buf + 2);          { get new sample from SPORT0 (from codec) }

{----------------------------------------------------------------------------}
{                        Pre-filter BFO                                      }
{----------------------------------------------------------------------------}

	call digi_bfo;           { Perform pre-filter BFO, sample in ax0     }
	ax0=ar;			 { returns result in ar }

{   ----- Bypass decimation-by-four stage if CW filtering not required ---   }

	ar=dm(CW_switch); 	{ CW filtering ? }
	none=PASS ar;
	if EQ jump no_dec_by4;

	call by4_dec;		 { otherwise decimate and filter }
				 { takes ax0, result in ax0 }

	ay0=dm(d4_cntr);   	 { use only every 4 th point }
	ar=ay0+1;
	ay0=3;
	ar=ar AND ay0;
	dm(d4_cntr)=ar;
	if NE jump interp1;

	call CW_filter;		{ CW filter will select either 100 or 500 Hz }
	jump interp2;

interp1:
	ax0=0;			{ otherwise send zeroes through filter       }
interp2:
	call by4_interpol;	{ send filtered data through the interpolator}

	dm(sigout_R)=ax0;
	dm(sigout_L)=ax0;

	dis sec_reg;
	rti;

{----------------------------------------------------------------------------}
{ CW filtering and LMS denoising are mutually exclusive. If CW filtering     }
{ is selected, then disable LMS functionality.                               }
{----------------------------------------------------------------------------}
no_dec_by4:

	call LMS;	 

	dm(sigout_R)=ax0;
	dm(sigout_L)=ax0;

	dis sec_reg;
	rti;

{----------------------------------------------------------------------------}
{           100 Hz CW filter centered at 800 Hz				     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{                   FILTER LENGTH = 120					     }
{									     }
{                       BAND  1       BAND  2       BAND  3		     }
{ LOWER BAND EDGE      .0000000      .1587300      .2116400		     }
{ UPPER BAND EDGE      .1269840      .1798940      .5000000		     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000		     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000		     }
{ DEVIATION            .0001374      .0013739      .0001374		     }
{ DEVIATION IN DB   -77.2410200      .0119252   -77.2410200		     }
{----------------------------------------------------------------------------}
.var/pm     coeffs1[FILTER_SIZE];            { Coefficients for the filter   }
.init24 coeffs1:
   0x000100,
   0x000700,
   0x000300,
   0xFFF800,
   0xFFEF00,
   0xFFF800,
   0x001100,
   0x002000,
   0x000C00,
   0xFFE200,
   0xFFCF00,
   0xFFF000,
   0x002800,
   0x003900,
   0x000D00,
   0xFFD600,
   0xFFD000,
   0xFFF800,
   0x001500,
   0x000900,
   0xFFFE00,
   0x001D00,
   0x003D00,
   0x000800,
   0xFF8E00,
   0xFF6300,
   0xFFF800,
   0x00D900,
   0x00FD00,
   0xFFFC00,
   0xFEC500,
   0xFEBF00,
   0x001800,
   0x016700,
   0x013E00,
   0xFFD700,
   0xFED100,
   0xFF2A00,
   0x001F00,
   0x006100,
   0xFFF900,
   0x001D00,
   0x011700,
   0x014B00,
   0xFF5A00,
   0xFCCE00,
   0xFD2E00,
   0x018200,
   0x05B900,
   0x045A00,
   0xFD5600,
   0xF7A700,
   0xFA5C00,
   0x03F800,
   0x0AA400,
   0x067000,
   0xFAC700,
   0xF3C800,
   0xF96100,
   0x062C00,
   0x0CC600,
   0x062C00,
   0xF96100,
   0xF3C800,
   0xFAC700,
   0x067000,
   0x0AA400,
   0x03F800,
   0xFA5C00,
   0xF7A700,
   0xFD5600,
   0x045A00,
   0x05B900,
   0x018200,
   0xFD2E00,
   0xFCCE00,
   0xFF5A00,
   0x014B00,
   0x011700,
   0x001D00,
   0xFFF900,
   0x006100,
   0x001F00,
   0xFF2A00,
   0xFED100,
   0xFFD700,
   0x013E00,
   0x016700,
   0x001800,
   0xFEBF00,
   0xFEC500,
   0xFFFC00,
   0x00FD00,
   0x00D900,
   0xFFF800,
   0xFF6300,
   0xFF8E00,
   0x000800,
   0x003D00,
   0x001D00,
   0xFFFE00,
   0x000900,
   0x001500,
   0xFFF800,
   0xFFD000,
   0xFFD600,
   0x000D00,
   0x003900,
   0x002800,
   0xFFF000,
   0xFFCF00,
   0xFFE200,
   0x000C00,
   0x002000,
   0x001100,
   0xFFF800,
   0xFFEF00,
   0xFFF800,
   0x000300,
   0x000700,
   0x000100;
									     
{----------------------------------------------------------------------------}
{           500 Hz CW filter centered at 800 Hz				     }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                     BANDPASS FILTER					     }
{									     }
{                   FILTER LENGTH = 120					     }
{									     }
{                       BAND  1       BAND  2       BAND  3		     }
{ LOWER BAND EDGE      .0000000      .1164021      .2433860		     }
{ UPPER BAND EDGE      .0952381      .2222222      .5000000		     }
{ DESIRED VALUE        .0000000     1.0000000      .0000000		     }
{ WEIGHTING          10.0000000     1.0000000    10.0000000		     }
{ DEVIATION            .0013155      .0131550      .0013155		     }
{ DEVIATION IN DB   -57.6181900      .1135177   -57.6181900		     }
{----------------------------------------------------------------------------}
.var/pm     coeffs2[FILTER_SIZE];            { Coefficients for the filter   }
.init24 coeffs2:
   0x000300,
   0xFFFF00,
   0x001000,
   0xFFDE00,
   0xFFB500,
   0xFFDB00,
   0x004400,
   0x007400,
   0x002500,
   0xFFC100,
   0xFFC400,
   0xFFFB00,
   0xFFE500,
   0xFFA500,
   0xFFDE00,
   0x007D00,
   0x00AB00,
   0x001E00,
   0xFFAA00,
   0xFFDC00,
   0x000700,
   0xFF8B00,
   0xFF2C00,
   0xFFE500,
   0x010000,
   0x00FD00,
   0x000800,
   0xFFB400,
   0x003500,
   0xFFFE00,
   0xFEBD00,
   0xFE7000,
   0x001D00,
   0x01B300,
   0x012B00,
   0xFFED00,
   0x003F00,
   0x010900,
   0xFFA300,
   0xFD2500,
   0xFD6F00,
   0x00AB00,
   0x027100,
   0x00F700,
   0x001300,
   0x021500,
   0x02BA00,
   0xFE5700,
   0xF9C300,
   0xFBDD00,
   0x01D900,
   0x030600,
   0xFFD000,
   0x01D600,
   0x099E00,
   0x088E00,
   0xF71200,
   0xE72700,
   0xF0EA00,
   0x0EFE00,
   0x1FB000,
   0x0EFE00,
   0xF0EA00,
   0xE72700,
   0xF71200,
   0x088E00,
   0x099E00,
   0x01D600,
   0xFFD000,
   0x030600,
   0x01D900,
   0xFBDD00,
   0xF9C300,
   0xFE5700,
   0x02BA00,
   0x021500,
   0x001300,
   0x00F700,
   0x027100,
   0x00AB00,
   0xFD6F00,
   0xFD2500,
   0xFFA300,
   0x010900,
   0x003F00,
   0xFFED00,
   0x012B00,
   0x01B300,
   0x001D00,
   0xFE7000,
   0xFEBD00,
   0xFFFE00,
   0x003500,
   0xFFB400,
   0x000800,
   0x00FD00,
   0x010000,
   0xFFE500,
   0xFF2C00,
   0xFF8B00,
   0x000700,
   0xFFDC00,
   0xFFAA00,
   0x001E00,
   0x00AB00,
   0x007D00,
   0xFFDE00,
   0xFFA500,
   0xFFE500,
   0xFFFB00,
   0xFFC400,
   0xFFC100,
   0x002500,
   0x007400,
   0x004400,
   0xFFDB00,
   0xFFB500,
   0xFFDE00,
   0x001000,
   0xFFFF00,
   0x000300;

CW_filter:
	i0=dm(filter_dl_ptr);
	l0=FILTER_SIZE;

{ Select appropiate CW filter }
	i4=^coeffs1;                    { assume 500 Hz filter coeffs }
	l4=0;				{ NOT CIRC !! }

	ar=dm(CW_switch);
	ay0=100;
	none=ar XOR ay0;
	if eq jump filt_1;
	i4=^coeffs2;                    { select 100 Hz filter coeffs }

filt_1:	m0=1;
	m4=1;
	dm(i0,m0)=ax0;			{ place new data in buffer }
	cntr=FILTER_SIZE-1;             { cntr=filtersize - 1 }
	mr=0, mx0=dm(i0,m0), my0=pm(i4,m4);
	do fir_loop until ce;
fir_loop:  mr=mr+mx0*my0(ss), mx0=dm(i0,m0), my0=pm(i4,m4);
	mr=mr+mx0*my0(rnd);
	if mv sat mr;
	ax0=mr1;			{ result }
	dm(filter_dl_ptr)=i0;		{ save pointer }
	rts;

{----------------------------------------------------------------------------}
{                 By-4 Decimator filter                                      }
{              FINITE IMPULSE RESPONSE (FIR)				     }
{            LINEAR PHASE DIGITAL FILTER DESIGN				     }
{                REMEZ EXCHANGE ALGORITHM				     }
{									     }
{                   FILTER LENGTH =  33					     }
{									     }
{                       BAND  1       BAND  2				     }
{ LOWER BAND EDGE      .0000000      .1250000				     }
{ UPPER BAND EDGE      .0555555      .5000000				     }
{ DESIRED VALUE       1.0000000      .0000000				     }
{ WEIGHTING           1.0000000    10.0000000				     }
{ DEVIATION            .0247328      .0024733				     }
{ DEVIATION IN DB      .2122129   -52.1345300				     }
{									     }
{----------------------------------------------------------------------------}
.var/pm     dec_coef[DEC4_SIZE]; { Coefficients for the filter }
.init24 dec_coef:
    0x005000, 
    0x007E00, 
    0x00AC00, 
    0x00A700, 
    0x004C00, 
    0xFF8C00, 
    0xFE7D00, 
    0xFD6500, 
    0xFCAF00, 
    0xFCD900, 
    0xFE4D00, 
    0x013600, 
    0x056A00, 
    0x0A6200, 
    0x0F4D00, 
    0x134100, 
    0x157500, 
    0x134100, 
    0x0F4D00, 
    0x0A6200, 
    0x056A00, 
    0x013600, 
    0xFE4D00, 
    0xFCD900, 
    0xFCAF00, 
    0xFD6500, 
    0xFE7D00, 
    0xFF8C00, 
    0x004C00, 
    0x00A700, 
    0x00AC00, 
    0x007E00, 
    0x005000; 

by4_dec:
	i0=dm(d4_in_ptr);
	l0=DEC4_SIZE;
	i4=^dec_coef;                   { point to coefficients }
	l4=0;				{ NOT CIRC !! }
	m0=1;
	m4=1;
	dm(i0,m0)=ax0;			{ place new data in buffer }
	cntr=DEC4_SIZE-1;               { cntr=DEC8_SIZE - 1 }
	mr=0, mx0=dm(i0,m0), my0=pm(i4,m4);
	do fir_loop1 until ce;
fir_loop1:  mr=mr+mx0*my0(ss), mx0=dm(i0,m0), my0=pm(i4,m4);
	mr=mr+mx0*my0(SS);
	my1=2;				{ correct for loss of gain }
	mx1=mr1;
	mr=mr0*my1(UU);
	mr0=mr1;
	mr1=mr2;
	mr=mr+mx1*my1(SU);
	sr=lshift mr0 by -1 (LO);
	sr=sr or ashift mr1 by -1 (HI);	
	ax0=sr0; 			{ result }
	dm(d4_in_ptr)=i0;		{ save pointer }
	rts;

by4_interpol:
	i0=dm(d4_out_ptr); 			{ select one of these }
	l0=DEC4_SIZE;
	i4=^dec_coef;                   { point to coefficients }
	l4=0;				{ NOT CIRC !! }
	m0=1;
	m4=1;
	dm(i0,m0)=ax0;			{ place new data in buffer }
	cntr=DEC4_SIZE-1;               { cntr=DEC8_SIZE - 1 }
	mr=0, mx0=dm(i0,m0), my0=pm(i4,m4);
	do fir_loop2 until ce;
fir_loop2:  mr=mr+mx0*my0(ss), mx0=dm(i0,m0), my0=pm(i4,m4);
	mr=mr+mx0*my0(SS);
	my1=4;				{ correct for loss of gain }
	mx1=mr1;
	mr=mr0*my1(UU);
	mr0=mr1;
	mr1=mr2;
	mr=mr+mx1*my1(SU);
	sr=lshift mr0 by -1 (LO);
	sr=sr or ashift mr1 by -1 (HI);	
	ax0=sr0; 			{ result }
	dm(d4_out_ptr)=i0;		{ save pointer }
	rts;

{----------------------------------------------------------------------------}
.ENDMOD;
