unit Extractor;
{unit to extract data partly based on a
 modified OpenAvionics project
 http://openavionics.sourceforge.net/}

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, CPort, showtraffic1 ;   

  type
  TSimpleEvent = procedure of object;
  TStringArray = array of string;
  RigData = class(TComponent)
  private
    FInputStr, FInStr : string;
    FComPort: TComPort;
    FOnInputStr: TSimpleEvent;
    FLongitude: double;
    FLatitude: double;
    FAltitude: double;

    FFrequency:string;

    FPortAuto: TComPort;
    FDate: TDateTime;
    FTU: TDateTime;
    FKts: double;
    FTrackAngle: double;
    FOnNewPos: TSimpleEvent;
    FMDev: double;
    procedure OnInputChar(Sender: TObject; Count: Integer);
    function GetActive: boolean;
    procedure SetActive(const Value: boolean);
    procedure SetPortAuto(const Value: TComPort);

  protected
  public
    property Active : boolean read GetActive write SetActive;
    property PortAuto: TComPort read FPortAuto write SetPortAuto;
    property ComPort: TComPort read FComPort write FComPort;
    property InputStr : string read FInputStr;
    property Latitude: double read FLatitude;
    property Longitude: double read FLongitude;
    property Altitude: double read FAltitude;
    property Date_GPS: TDateTime read FDate;
    property TU_GPS: TDateTime read FTU;
    property Kts: double read FKts;
    property TrackAngle: double read FTrackAngle;
    property MagneticDeviation: double read FMDev;

    property Frequency: string read FFrequency;

    constructor Create(AOwner: TComponent; AName : string);
    destructor Destroy;

    procedure Reset;
   

    property OnInputStr : TSimpleEvent read FOnInputStr write FOnInputStr;
    property OnNewPosition : TSimpleEvent read FOnNewPos write FOnNewPos;

  end;

implementation

{ RigData }

const
  CR : Char = #13;
  LF : Char = #10;

  chrFinTransmission : Char = #59;     //(';")    end of data marker for Kenwood



constructor RigData.Create(AOwner: TComponent; AName: string);
begin
  inherited Create(AOwner);
  Name := AName;
  FComPort:= TComPort.Create(Self);
  with FComport do
  begin
    Port := 'COM1';
    BaudRate := br57600;
    Databits := dbEight;
    StopBits := sbOneStopBit;
    Parity.Bits := prNone;
    //  FlowControl.FlowControl := fcNone;
    FlowControl.FlowControl := fcHardware;

    TriggersOnRxChar := True;
    OnRxChar := OnInputChar;
  end;
  Reset;
end;

destructor RigData.Destroy;
begin
  FComPort.Free;
  inherited Destroy;
end;

function RigData.GetActive: boolean;
begin

end;


procedure RigData.SetActive(const Value: boolean);
begin
  if Value then FComPort.Open else FComPort.Close;
end;

procedure RigData.Reset;
begin
  FInputStr := '';
end;

procedure RigData.OnInputChar(Sender: TObject; Count: Integer);
var Ch : string;
    i : Integer;
    RXFrequency:integer;
    data:string;
begin

  for i := 1 to Count do
  begin
  /// showtraffic.Memo1.lines.add(FInputStr);
    FComPort.ReadStr(Ch, 1);

    if (Ch = chrFinTransmission) then
      begin
      /// showtraffic.Memo1.lines.add(FInputStr);
      if Assigned(FOnInputStr) then FOnInputStr;

     ////  showtraffic.Memo1.lines.add(FInputStr);


     if copy(FinputStr,pos('MD',Finputstr),2)='MD' then
       begin
       showtraffic.Label3.caption:=finputstr;
       showtraffic.Edit4.text:= finputstr; //copy(finputstr,3,1);
       end
     else if copy(FinputStr,pos('FA',Finputstr),2)='FA' then showtraffic.Label1.caption:=finputstr
     else if copy(FinputStr,pos('FB',Finputstr),2)='FB' then showtraffic.Label3.caption:=finputstr;

     begin
       // for a Kenwood, write VFO A frequency
       data:=finputstr;
       if ((pos('FA',data)=1)or(pos('FB',data)=1))  and (length(data) =13) then   // filters the data
         begin
           delete(data,1,2);//delete FA
           if length(trim(data))<18 then
             if strtoint(copy(data,2,1))=1 then
               RxFrequency:=strtoint(copy(data,2,10))
             else RxFrequency:=strtoint(copy(data,3,10));

             showtraffic.label1.Caption := format( '%.1d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] ) ;

             Ffrequency := format( '%.1d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] );

              showtraffic.Edit3.text:=format( '%.1d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] );
         end;
      end;

     ///////////////////////////////
    begin
       // for a Kenwood, write VFO A frequency   using the IF data stream
       data:=finputstr;
       if (pos('IF',data)=1) then   // filters the data
         begin
           delete(data,1,2);//delete IF
           if length(trim(data))<36 then
             if strtoint(copy(data,2,1))=1 then
               RxFrequency:=strtoint(copy(data,2,10))
             else RxFrequency:=strtoint(copy(data,3,10));

             showtraffic.label1.Caption := format( '%.1d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] ) ;

             Ffrequency := format( '%.1d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] );

              showtraffic.Edit3.text:=format( '%.1d.%.3d.%.2d',
               [RxFrequency div 1000000,
               ( RxFrequency mod 1000000 ) div 1000,
               (RxFrequency mod 1000) div 10 ] );
         end;
      end;


      ////////////////

      if Assigned(FOnInputStr) then FOnInputStr;
      FInputStr := '';
    end

    else if (Ch <> CR) and (Ch <> LF) then
      begin FInputStr := FInputStr + Ch;

      end;
  end;

end;


procedure RigData.SetPortAuto(const Value: TComPort);
begin
  FPortAuto := Value;
end;


end.
