unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, OmniRig_TLB, Buttons,  ValueFrm, FlagFrm,
  ActnMan, ActnColorMaps, XPStyleActnCtrls, ActnList;


const
  HighParam = 30;
  HighValue = 5; //PM_FREQ ... PM_RITOFFSET

  ParamCodes: array[0..HighParam] of integer = (
    PM_UNKNOWN, PM_FREQ, PM_FREQA, PM_FREQB, PM_PITCH, PM_RITOFFSET, PM_RIT0,
    PM_VFOAA, PM_VFOAB, PM_VFOBA, PM_VFOBB, PM_VFOA, PM_VFOB, PM_VFOEQUAL,
    PM_VFOSWAP, PM_SPLITON, PM_SPLITOFF, PM_RITON, PM_RITOFF, PM_XITON,
    PM_XITOFF, PM_RX, PM_TX, PM_CW_U, PM_CW_L, PM_SSB_U, PM_SSB_L, PM_DIG_U,
    PM_DIG_L, PM_AM, PM_FM);

  ParamNames: array[0..HighParam] of string = (
    'UNKNOWN', 'FREQ', 'FREQA', 'FREQB', 'PITCH', 'RITOFFSET', 'RIT0',
    'VFOAA', 'VFOAB', 'VFOBA', 'VFOBB', 'VFOA', 'VFOB', 'VFOEQUAL',
    'VFOSWAP', 'SPLITON', 'SPLITOFF', 'RITON', 'RITOFF', 'XITON',
    'XITOFF', 'RX', 'TX', 'CW_U', 'CW_L', 'SSB_U', 'SSB_L', 'DIG_U',
    'DIG_L', 'AM', 'FM');

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    Label3: TLabel;
    TabSheet3: TTabSheet;
    Memo2: TMemo;
    Image1: TImage;
    RadioGroup5: TRadioGroup;
    TabSheet4: TTabSheet;
    Button2: TButton;
    Label5: TLabel;
    Button3: TButton;
    RichEdit1: TRichEdit;
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    CheckBox1: TCheckBox;
    Edit3: TEdit;
    TwilightColorMap1: TTwilightColorMap;
    Memo1: TMemo;
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RadioGroup5Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);


  private
    procedure VisibleChangeEvent(Sender: TObject);
    procedure RigTypeChangeEvent(Sender: TObject; RigNumber: Integer);
    procedure StatusChangeEvent(Sender: TObject; RigNumber: Integer);
    procedure ParamsChangeEvent(Sender: TObject; RigNumber: Integer; Params: Integer);
    procedure CustomReplyEvent(Sender: TObject; RigNumber: Integer; Command,
      Reply: OleVariant);
    function HexToSafeArray(Hex: string): Variant;
    function TextToSafeArray(Txt: string): Variant;
    function SafeArrayToHex(Arr: Variant): string;
  public
    OmniRig: TOmniRigX;
    procedure SetFlagParam(Par: integer);
    procedure SetValueParam(Par, Value: integer);
  end;


var
  Form1: TForm1;
  ComFile: THandle;
  s:string;


  
implementation


{$R *.dfm}


function TForm1.SafeArrayToHex(Arr: Variant): string;
var
  P: PByteArray;
  i: integer;
begin
  Result := '';

  try
    if VarArrayDimCount(Arr) <> 1 then Exit;
    if VarArrayLowBound(Arr, 1) <> 0 then Exit;

    P := VarArrayLock(Arr);
    try for i:=0 to VarArrayHighBound(Arr, 1) do Result := Result + IntToHex(P[i], 2);
    finally VarArrayUnlock(Arr); end;

  except on E: Exception do
   begin
     Memo1.Lines.Add(E.Message); end;
  end;
end;


function TForm1.TextToSafeArray(Txt: string): Variant;
var
  P: PByte;
begin
  Result := VarArrayCreate([0, Length(Txt)-1], varByte);
  if Text <> '' then
    try
      P := VarArrayLock(Result);
      try Move(Txt[1], P^, Length(Txt));
      finally VarArrayUnlock(Result); end;
    except on E: Exception do
      begin
       Memo1.Lines.Add(E.Message); end;
     end;
end;


function TForm1.HexToSafeArray(Hex: string): Variant;
var
  P: PByteArray;
  i, H: integer;
begin
  H := (Length(Hex) div 2) - 1;
  Result := VarArrayCreate([0, H], varByte);

  try
    P := VarArrayLock(Result);
    try for i:=0 to H do P[i] := StrToInt('$' + Copy(Hex, i*2+1, 2));
    finally VarArrayUnlock(Result); end;

  except on E: Exception do
   begin
     Memo1.Lines.Add(E.Message); end;
  end;
end;




procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  OmniRig.Disconnect;
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Cmd, Trm: Variant;
  lengthi:integer;
  length:string;
begin
  if checkbox1.checked = true
    then
      begin
        Cmd := TextToSafeArray(Edit1.Text);
        Trm := TextToSafeArray(Edit2.Text);
      end
    else
      begin
        Cmd := HexToSafeArray(Edit1.Text);
        Trm := HexToSafeArray(Edit2.Text);
      end;

      length:=edit3.text;
      lengthi:=strtoint(length);
      OmniRig.Rig1.SendCustomCommand(Cmd, lengthi, Trm);  //do not wait for reply

{Examples:
ReplyLength=0 ;do not wait for a reply
ReplyLength=5 ;wait for a 5-byte reply

ReplyEnd=     ;do not wait for a reply
ReplyEnd=(;)  ;wait for a reply that ends with ";"
ReplyEnd=FD   ;wait for a reply that ends with 0xFD  }
  
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  OmniRig.Autoconnect:=true;
  OmniRig.Connect;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Omnirig.dialogvisible:=true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
{Examples:
ReplyLength=0 ;do not wait for a reply
ReplyLength=5 ;wait for a 5-byte reply

ReplyEnd=     ;do not wait for a reply
ReplyEnd=(;)  ;wait for a reply that ends with ";"
ReplyEnd=FD   ;wait for a reply that ends with 0xFD  }
  omnirig.Rig1.SendCustomCommand('FB;',0,';');
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  OmniRig.Rig1.vfo:=pm_vfoAA;  //select VFO A
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  OmniRig.Rig1.vfo:=pm_VFOBB;   //select VFO B
end;




procedure TForm1.Button7Click(Sender: TObject);
begin
  OmniRig.Rig1.vfo:=pm_VFOAA;   //select VFO A
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  OmniRig.Rig1.vfo:=pm_VFOBB;   //select VFO B
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  //creating the automation object in code
  //to avoid installation on the palette
  OmniRig := TOmniRigX.Create(Self);
  OmniRig.OnVisibleChange := VisibleChangeEvent;
  OmniRig.OnRigTypeChange := RigTypeChangeEvent;
  OmniRig.OnStatusChange := StatusChangeEvent;
  OmniRig.OnParamsChange := ParamsChangeEvent;
  OmniRig.OnCustomReply := CustomReplyEvent;
  OmniRig.Rig1.vfo:=pm_VFOAA;   //select VFO A
end;


procedure TForm1.RadioGroup5Click(Sender: TObject);
begin  // to select the radio mode using the PC radio buttons
   case RadioGroup5.ItemIndex of
     0:  OmniRig.Rig1.mode:=pm_SSB_L;
     1:  OmniRig.Rig1.mode:=pm_SSB_U;
     2:  OmniRig.Rig1.mode:=pm_CW_U;
     3:  OmniRig.Rig1.mode:=pm_FM;
     4:  OmniRig.Rig1.mode:=pm_AM;
     5:  OmniRig.Rig1.mode:=pm_DIG_L;
   end; //end case
end;

//------------------------------------------------------------------------------
//                           Omni-Rig events
//------------------------------------------------------------------------------
procedure TForm1.VisibleChangeEvent(Sender: TObject);
begin
  ///  if OmniRig.DialogVisible
  ///   then Label1.Caption := 'Dialog VISIBLE'
  ///   else Label1.Caption := 'Dialog invisible';
end;




procedure TForm1.RigTypeChangeEvent(Sender: TObject; RigNumber: Integer);
begin
  //we are testing only Rig1 because the two rig objects are identical
  if RigNumber <> 1 then Exit;
  Label5.Caption := 'Rig type: ' + OmniRig.Rig1.Get_RigType;
  Memo1.Lines.Add(Label2.Caption);
end;


procedure TForm1.ParamsChangeEvent(Sender: TObject; RigNumber,
  Params: Integer);
 // RichEdit1.Lines.Add('Parameters changed: ' + IntToHex(Params, 8));
 var
rigmode:integer;
rigfreqf:real;
rigfreqstr:string;
begin
  try
    BEGIN
      if RigNumber <> 1 then Exit;

      Memo1.Lines.Add(Label3.Caption);  //mode
       Memo1.Lines.Add(Label1.Caption); //freq

       rigMode:=  OmniRig.rig1.Mode;
       case rigmode of

        PM_CW_U: begin
                   Label3.caption:='CW';
                   RadioGroup5.ItemIndex:=2;
                end;

        PM_CW_L:  begin
                    Label3.caption:='CW';
                    RadioGroup5.ItemIndex:=2;
                end;
        PM_SSB_U:  begin
                    Label3.caption:='USB';
                    RadioGroup5.ItemIndex:=1;
                  end;
         PM_SSB_L:  begin
                      Label3.caption:='LSB';
                      RadioGroup5.ItemIndex:=0;
                    end;
         PM_AM: begin
                  Label3.caption:='AM';
                  RadioGroup5.ItemIndex:=4;
                end;
         PM_FM:begin
                  Label3.caption:='FM';
                  RadioGroup5.ItemIndex:=3;
                end;
          PM_DIG_U: begin
                      Label3.caption:='RTTY';
                      RadioGroup5.ItemIndex:=5;
                    end;
    //  PM_DIG_L: begin
    //               Label3.caption:='RTTY-R';
    //               RadioGroup5.ItemIndex:=2;
    //            end;

  end; //case


  if OmniRig.Rig1.Get_Rit =$00020000 then//if on
    rigfreqf :=  (OmniRig.Rig1.Freq + OmniRig.Rig1.RitOffset) * 0.000001//with offset
  else
    rigfreqf :=  (OmniRig.Rig1.Freq) * 0.000001;//with offset

  rigfreqstr:=floattostr(rigfreqf);
  if pos('.',rigfreqstr)<1 then
   // label1.caption := rigfreqstr+'.00'
    begin
      label1.caption:=floattostrf(strtofloat(rigfreqstr),ffFixed,7,5);
    end
  else
   // label1.caption:=rigfreqstr;
   begin
     label1.caption:=floattostrf(strtofloat(rigfreqstr),ffFixed,7,5);

   end;


//******************
  END
  except
  end;

end;



procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  If checkbox1.Checked then
    begin
      checkbox1.Checked:=true;
      checkbox1.Caption:='Text Format';
    end
  else
    begin
      checkbox1.Checked:=false;
      checkbox1.Caption:='Hex Format';
    end;
end;

procedure TForm1.CustomReplyEvent(Sender: TObject; RigNumber: Integer;
  Command, Reply: OleVariant);
begin
  if RigNumber <> 1 then Exit;
  Memo1.Lines.Add(Format('Reply to custom command "%s":'#13'"%s"',
    [SafeArrayToHex(Command), SafeArrayToHex(Reply)]));
end;


procedure TForm1.StatusChangeEvent(Sender: TObject; RigNumber: Integer);
var
  rigmode:integer;
  rigfreqf:real;
  rigfreqstr:string;
begin
  try
    BEGIN
      if RigNumber <> 1 then Exit;

      Memo1.Lines.Add(Label3.Caption); //mode
      Memo1.Lines.Add(Label1.Caption);  //freq

      Label2.Caption := 'Status: ' + OmniRig.Rig1.Get_StatusStr;

      rigMode:=  OmniRig.rig1.Mode;
    case rigmode of
      PM_CW_U:   Label3.caption:='CW';
      PM_CW_L:  Label3.caption:='CW';
      PM_SSB_U:  Label3.caption:='USB';
      PM_SSB_L:  Label3.caption:='LSB';
      PM_AM: Label3.caption:='AM';
      PM_FM:Label3.caption:='FM';
      PM_DIG_U: Label3.caption:='RTTY';
      PM_DIG_L: Label3.caption:='RTTY-R';

    end;//case

    if OmniRig.Rig1.Get_Rit =$00020000 then//if on
      rigfreqf :=  (OmniRig.Rig1.Freq + OmniRig.Rig1.RitOffset) * 0.000001//with offset
    else
      rigfreqf :=  (OmniRig.Rig1.Freq) * 0.000001;//with offset

    rigfreqstr:=floattostr(rigfreqf);
    if pos('.',rigfreqstr)<1 then
      // label1.caption := rigfreqstr+'.00'
      begin
        label1.caption:=floattostrf(strtofloat(rigfreqstr),ffFixed,7,5);
      end
    else
     // label1.caption:=rigfreqstr;
   begin
     label1.caption:=floattostrf(strtofloat(rigfreqstr),ffFixed,7,5);
   end;
    END
  except
  //
  end;

end;


procedure TForm1.SetFlagParam(Par: integer);
begin
  case Par of
    PM_RIT0:                                   OmniRig.Rig1.ClearRit;
    PM_VFOAA, PM_VFOAB, PM_VFOBA, PM_VFOBB,
    PM_VFOA, PM_VFOB, PM_VFOEQUAL, PM_VFOSWAP: OmniRig.Rig1.Vfo := Par;
    PM_SPLITON, PM_SPLITOFF:                   OmniRig.Rig1.Split := Par;
    PM_RITON, PM_RITOFF:                       OmniRig.Rig1.Rit := Par;
    PM_XITON, PM_XITOFF:                       OmniRig.Rig1.Xit := Par;
    PM_RX, PM_TX:                              OmniRig.Rig1.Tx := Par;
    PM_CW_U, PM_CW_L, PM_SSB_U, PM_SSB_L,
    PM_DIG_U, PM_DIG_L, PM_AM, PM_FM:          OmniRig.Rig1.Mode := Par;
    end;
end;

procedure TForm1.SetValueParam(Par, Value: integer);
begin
  case Par of
    PM_FREQ:      OmniRig.Rig1.Freq := Value;
    PM_FREQA:     OmniRig.Rig1.FreqA := Value;
    PM_FREQB:     OmniRig.Rig1.FreqB := Value;
    PM_PITCH:     OmniRig.Rig1.Pitch := Value;
    PM_RITOFFSET: OmniRig.Rig1.RitOffset := Value;
    end;
end;


 
end.
